//>>> _using
using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using SharpDX;
using SharpDX.Direct3D11;
using SharpDX.Windows;
//<<< _using

namespace Framefield.Core.ID878477ec_b4da_4c98_9e6c_bec70a7096b9
{
    public class Class_Set_Variable : OperatorPart.Function, Framefield.Core.OperatorPartTraits.IVariableAccessor
    {
        //>>> _inputids
        private enum InputId
        {
            Subtree = 0,
            Name = 1,
            Value = 2
        }
        //<<< _inputids

        public string VariableName
        {
            get
            {
                return OperatorPartUtilities.GetInputTextValue(OperatorPart.Connections[(int)InputId.Name]);
            }
        }

        public override OperatorPartContext Eval(OperatorPartContext context, List<OperatorPart> inputs, int outputIdx)
        {
            //>>> _params
            var Subtree = inputs[(int)InputId.Subtree];
            var Name = inputs[(int)InputId.Name].Eval(context).Text;
            var Value = inputs[(int)InputId.Value].Eval(context).Value;
            //<<< _params

            float? previousValue = null;
            if (context.Variables.ContainsKey(Name))
            {
                previousValue = context.Variables[Name];
                context.Variables[Name] = Value;
            }
            else
                context.Variables.Add(Name, Value);
            
//            var invalidator = new OperatorPart.InvalidateVariableAccessors(Name);
//            Subtree.TraverseWithFunctionUseSpecificBehavior(invalidator, null);
            context = Subtree.Eval(context);
            
            if (previousValue.HasValue)
                context.Variables[Name] = previousValue.Value;
            else
                context.Variables.Remove(Name);
            return context;
        }
    }
}
